(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13753,        290]*)
(*NotebookOutlinePosition[     15187,        338]*)
(*  CellTagsIndexPosition[     15116,        332]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ 
      Check\ the\ NRC\ from\ Takens\ Paper\ in\ BIX\ *) \)\(\
\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ 
      IMPORTANT : \ THIS\ is\ the\ correct\ version, \ 
      not\ the\ other\ BIX - files, \ 
      there\ was\ a\ "\<sign-mistake\>"\ in\ the\ sorting\ of\ \(\(Pos\)\(.\)\
\)/Neg . \(-Eigenvalues\), \ because\ we\ go\ to\ Big\ Bang, \ 
      i . e . \ 
          t\ goes\ to\ MINUS\ Infiniy*) \)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)\( (*\ Do\ everything\ in\ a\ For - Loop\ for\ m, \ 
      thus\ testing\ everything\ at\ once\ and\ printing\ the\ output\ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      Now\ compute\ the\ Koeffs\ direclty\ via\ the\ formula\ and\ a\ for - 
        loop\ *) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ 
      Parameters\ *) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(k\  = \
\ 1\[IndentingNewLine]\[IndentingNewLine]
    a\  = \ 1\[IndentingNewLine]
    b = \ 1\[IndentingNewLine]
    c = 1\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine]\
\[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
**************) \[IndentingNewLine] (*\ 1  st\ For - Loop, \ 
      out\ of\ three, \ 
      for\ the\ 3\ different\ possible\ forms\ of\ the\ continued\ fraction\ \
with\ period\ 3\ *) \[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
******************) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      Now\ start\ for\ u = \(\([m, b, c, a,  ... ]\)\ and\ m = \(1.  .. \) 
            a\)\ *) \[IndentingNewLine]\ \[IndentingNewLine]
    Print["\<For u=[m,b,c,a,...] and m=1...a\>"]\[IndentingNewLine]\
\[IndentingNewLine]
    For[m = 1, 
      m < a + 1, \(m++\), \[IndentingNewLine]\[IndentingNewLine]c0\  = \ 
        m^2 + m*c + m^2*b*c - b*m - a*m - a*c - a*b*c*m - 
          1; \[IndentingNewLine]c1 = \ 
        a*b*c + a + b - c - 2*m - 2*m*b*c; \[IndentingNewLine]c2 = \ 
        1 + b*c; \[IndentingNewLine]\[IndentingNewLine]k1 = 
        c0 - c1 + c2; \[IndentingNewLine]k2 = c0; \[IndentingNewLine]k3 = 
        c2; \[IndentingNewLine]\[IndentingNewLine]u = \ 
        FromContinuedFraction[{m, {b, c, 
              a}}]; \[IndentingNewLine]\[IndentingNewLine]l1\  = \ \((\(-6\) 
              u)\)/\((1 + u + u^2)\); \[IndentingNewLine]l2\  = \ \((6 + 
              6  u)\)/\((1 + u + 
              u^2)\); \[IndentingNewLine]l3\  = \ \((6  u + 6  u^2)\)/\((1 + 
              u + u^2)\); \[IndentingNewLine]\[IndentingNewLine]EVlist\  = \ \
{\(-N[l1]\), \(-N[l2]\), \(-N[l3]\)}; \  (*\ 
        IMPORTANT : \ Reverse\ the\ signs\ of\ the\ Eigenvalues, \ 
        because\ we\ go\ to\ Big\ Bang, \ 
        i . e . \ 
            t\ goes\ to\ MINUS\ Infinity\ *) \[IndentingNewLine]PositiveEV\  \
= \ Select[EVlist, # > 0\  &]; \[IndentingNewLine]NegativeEV\  = \ 
        Select[EVlist, # < 
              0\  &]; \[IndentingNewLine]\[IndentingNewLine]N9 = \ \(-Min[
            NegativeEV]\); \[IndentingNewLine]n9 = \ \(-Max[
            NegativeEV]\); \[IndentingNewLine]m9 = \ 
        Min[PositiveEV]; \[IndentingNewLine]M9 = \ 
        Max[PositiveEV]; \[IndentingNewLine]\[IndentingNewLine]beta9 = \ 
        Ceiling[\((N9 + k \((M9 + n9)\))\)/
            n9]; \[IndentingNewLine]alpha9\  = \ 
        Ceiling[\((M9 + beta9 \((N9 + m9)\))\)/
            m9]; \[IndentingNewLine]\[IndentingNewLine]Print["\<m=\>", 
        m, "\< alpha= \>", alpha9, "\< beta=\>", beta9, "\<  k1=\>", 
        k1, "\<  k2=\>", k2\ , "\<  k3=\>", 
        k3];\[IndentingNewLine]\[IndentingNewLine]]\ \[IndentingNewLine]\
\[IndentingNewLine]\[IndentingNewLine] (*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
\(**\)\(**\)**************) \[IndentingNewLine] (*\ 2  nd\ For - Loop, \ 
      out\ of\ three, \ 
      for\ the\ 3\ different\ possible\ forms\ of\ the\ continued\ fraction\ \
with\ period\ 3\ *) \[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)**********************) \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
      Now\ start\ for\ u = \(\([m, c, a, b,  ... ]\)\ and\ m = \(1.  .. \) 
            b\)\ *) \[IndentingNewLine]\ \[IndentingNewLine]
    Print["\<For u=[m,c,a,b,...] and m=1...b\>"]\[IndentingNewLine]\
\[IndentingNewLine]
    For[m = 1, 
      m < b + 1, \(m++\), \[IndentingNewLine]\[IndentingNewLine]c0\  = \ 
        m^2 + m*a + m^2*c*a - c*m - b*m - b*a - a*b*c*m - 
          1; \[IndentingNewLine]c1 = \ 
        a*b*c + b + c - a - 2*m - 2*m*c*a; \[IndentingNewLine]c2 = \ 
        1 + c*a; \[IndentingNewLine]\[IndentingNewLine]k1 = 
        c0 - c1 + c2; \[IndentingNewLine]k2 = c0; \[IndentingNewLine]k3 = 
        c2; \[IndentingNewLine]\[IndentingNewLine]u = \ 
        FromContinuedFraction[{m, {c, a, 
              b}}]; \[IndentingNewLine]\[IndentingNewLine]l1\  = \ \((\(-6\) 
              u)\)/\((1 + u + u^2)\); \[IndentingNewLine]l2\  = \ \((6 + 
              6  u)\)/\((1 + u + 
              u^2)\); \[IndentingNewLine]l3\  = \ \((6  u + 6  u^2)\)/\((1 + 
              u + u^2)\); \[IndentingNewLine]\[IndentingNewLine]EVlist\  = \ \
{\(-N[l1]\), \(-N[l2]\), \(-N[l3]\)}; \  (*\ 
        IMPORTANT : \ Reverse\ the\ signs\ of\ the\ Eigenvalues, \ 
        because\ we\ go\ to\ Big\ Bang, \ 
        i . e . \ 
            t\ goes\ to\ MINUS\ Infinity\ *) \[IndentingNewLine]PositiveEV\  \
= \ Select[EVlist, # > 0\  &]; \[IndentingNewLine]NegativeEV\  = \ 
        Select[
          EVlist, # < 
              0\  &]; \[IndentingNewLine]\[IndentingNewLine]N9 = \ \(-Min[
            NegativeEV]\); \[IndentingNewLine]n9 = \ \(-Max[
            NegativeEV]\); \[IndentingNewLine]m9 = \ 
        Min[PositiveEV]; \[IndentingNewLine]M9 = \ 
        Max[PositiveEV]; \[IndentingNewLine]\[IndentingNewLine]beta9 = \ 
        Ceiling[\((N9 + k \((M9 + n9)\))\)/
            n9]; \[IndentingNewLine]alpha9\  = \ 
        Ceiling[\((M9 + beta9 \((N9 + m9)\))\)/
            m9]; \[IndentingNewLine]\[IndentingNewLine]Print["\<m=\>", 
        m, "\< alpha= \>", alpha9, "\< beta=\>", beta9, "\<  k1=\>", 
        k1, "\<  k2=\>", k2\ , "\<  k3=\>", 
        k3];\[IndentingNewLine]\[IndentingNewLine]]\ \[IndentingNewLine]\
\[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
**************) \[IndentingNewLine] (*\ 3  rd\ For - Loop, \ 
      out\ of\ three, \ 
      for\ the\ 3\ different\ possible\ forms\ of\ the\ continued\ fraction\ \
with\ period\ 3\ *) \[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)**********************) \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
      Now\ start\ for\ u = \(\([m, a, b, c,  ... ]\)\ and\ m = \(1.  .. \) 
            c\)\ *) \[IndentingNewLine]\ \[IndentingNewLine]
    Print["\<For u=[m,a,b,c,...] and m=1...c\>"]\[IndentingNewLine]\
\[IndentingNewLine]
    For[m = 1, 
      m < c + 1, \(m++\), \[IndentingNewLine]\[IndentingNewLine]c0\  = \ 
        m^2 + m*b + m^2*a*b - a*m - c*m - c*b - a*b*c*m - 
          1; \[IndentingNewLine]c1 = \ 
        a*b*c + c + a - b - 2*m - 2*m*a*b; \[IndentingNewLine]c2 = \ 
        1 + a*b; \[IndentingNewLine]\[IndentingNewLine]k1 = 
        c0 - c1 + c2; \[IndentingNewLine]k2 = c0; \[IndentingNewLine]k3 = 
        c2; \[IndentingNewLine]\[IndentingNewLine]u = \ 
        FromContinuedFraction[{m, {a, b, 
              c}}]; \[IndentingNewLine]\[IndentingNewLine]l1\  = \ \((\(-6\) 
              u)\)/\((1 + u + u^2)\); \[IndentingNewLine]l2\  = \ \((6 + 
              6  u)\)/\((1 + u + 
              u^2)\); \[IndentingNewLine]l3\  = \ \((6  u + 6  u^2)\)/\((1 + 
              u + u^2)\); \[IndentingNewLine]\[IndentingNewLine]EVlist\  = \ \
{\(-N[l1]\), \(-N[l2]\), \(-N[l3]\)}; \  (*\ 
        IMPORTANT : \ Reverse\ the\ signs\ of\ the\ Eigenvalues, \ 
        because\ we\ go\ to\ Big\ Bang, \ 
        i . e . \ 
            t\ goes\ to\ MINUS\ Infinity\ *) \[IndentingNewLine]PositiveEV\  \
= \ Select[EVlist, # > 0\  &]; \[IndentingNewLine]NegativeEV\  = \ 
        Select[EVlist, # < 
              0\  &]; \[IndentingNewLine]\[IndentingNewLine]N9 = \ \(-Min[
            NegativeEV]\); \[IndentingNewLine]n9 = \ \(-Max[
            NegativeEV]\); \[IndentingNewLine]m9 = \ 
        Min[PositiveEV]; \[IndentingNewLine]M9 = \ 
        Max[PositiveEV]; \[IndentingNewLine]\[IndentingNewLine]beta9 = \ 
        Ceiling[\((N9 + k \((M9 + n9)\))\)/
            n9]; \[IndentingNewLine]alpha9\  = \ 
        Ceiling[\((M9 + beta9 \((N9 + m9)\))\)/
            m9]; \[IndentingNewLine]\[IndentingNewLine]Print["\<m=\>", 
        m, "\< alpha= \>", alpha9, "\< beta=\>", beta9, "\<  k1=\>", 
        k1, "\<  k2=\>", k2\ , "\<  k3=\>", 
        k3];\[IndentingNewLine]\[IndentingNewLine]]\)\)\)], "Input",
  CellTags->"param"],

Cell[BoxData[
    \(1\)], "Output",
  CellTags->"param"],

Cell[BoxData[
    \(1\)], "Output",
  CellTags->"param"],

Cell[BoxData[
    \(1\)], "Output",
  CellTags->"param"],

Cell[BoxData[
    \(1\)], "Output",
  CellTags->"param"],

Cell[BoxData[
    \("For u=[m,b,c,a,...] and m=1...a"\)], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]16\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]2\[InvisibleSpace]"  k2="\
\[InvisibleSpace]\(-2\)\[InvisibleSpace]"  k3="\[InvisibleSpace]2\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 16, " beta=", 4, "  k1=", 2, "  k2=", -2, "  k3=", 
        2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    \("For u=[m,c,a,b,...] and m=1...b"\)], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]16\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]2\[InvisibleSpace]"  k2="\
\[InvisibleSpace]\(-2\)\[InvisibleSpace]"  k3="\[InvisibleSpace]2\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 16, " beta=", 4, "  k1=", 2, "  k2=", -2, "  k3=", 
        2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    \("For u=[m,a,b,c,...] and m=1...c"\)], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]16\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]2\[InvisibleSpace]"  k2="\
\[InvisibleSpace]\(-2\)\[InvisibleSpace]"  k3="\[InvisibleSpace]2\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 16, " beta=", 4, "  k1=", 2, "  k2=", -2, "  k3=", 
        2],
      Editable->False]], "Print",
  CellTags->"param"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 933}, {0, 643}},
WindowSize->{917, 605},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "param"->{
    Cell[1776, 53, 10078, 173, 2850, "Input",
      CellTags->"param"],
    Cell[11857, 228, 56, 2, 29, "Output",
      CellTags->"param"],
    Cell[11916, 232, 56, 2, 29, "Output",
      CellTags->"param"],
    Cell[11975, 236, 56, 2, 29, "Output",
      CellTags->"param"],
    Cell[12034, 240, 56, 2, 29, "Output",
      CellTags->"param"],
    Cell[12093, 244, 87, 2, 25, "Print",
      CellTags->"param"],
    Cell[12183, 248, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[12642, 259, 87, 2, 25, "Print",
      CellTags->"param"],
    Cell[12732, 263, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[13191, 274, 87, 2, 25, "Print",
      CellTags->"param"],
    Cell[13281, 278, 456, 9, 25, "Print",
      CellTags->"param"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"param", 14341, 305}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 10078, 173, 2850, "Input",
  CellTags->"param"],
Cell[11857, 228, 56, 2, 29, "Output",
  CellTags->"param"],
Cell[11916, 232, 56, 2, 29, "Output",
  CellTags->"param"],
Cell[11975, 236, 56, 2, 29, "Output",
  CellTags->"param"],
Cell[12034, 240, 56, 2, 29, "Output",
  CellTags->"param"],
Cell[12093, 244, 87, 2, 25, "Print",
  CellTags->"param"],
Cell[12183, 248, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[12642, 259, 87, 2, 25, "Print",
  CellTags->"param"],
Cell[12732, 263, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[13191, 274, 87, 2, 25, "Print",
  CellTags->"param"],
Cell[13281, 278, 456, 9, 25, "Print",
  CellTags->"param"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

